/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.data.api;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.invoice.domain.AInvoiceService;
import com.android.invoice.domain.model.AInvoiceDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@RequestMapping(value={"/android/invoice"})
public class InvoiceController
extends AndroidController<AInvoiceDto> {
    public InvoiceController(Application app, AndroidService<AInvoiceDto> service) {
        super(app, service);
    }

    @PostMapping(value={"/calc-discount"})
    public ResponseEntity<Map<String, Object>> calcDiscount(@RequestBody List<AInvoiceDto> invoiceDto) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid || invoiceDto.isEmpty()) {
            return null;
        }
        return ((AInvoiceService)this.service).calcDiscount(invoiceDto.get(0));
    }

    @DeleteMapping
    public ResponseEntity<Map<String, Object>> deleteInvoice(@RequestParam(value="server-id") String serverId, @RequestParam(value="type-int") String typeInt) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        return ((AInvoiceService)this.getService()).deleteInvoice(serverId, ConvertStr.parseNullSafeInt((String)typeInt));
    }
}

